<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/code39.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends PDF_Code39
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'DELIVERY CHALLAN';

        $this->SetFont('Arial', 'B', 18);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(0,10, $rep_name,0,0,'L');
        $this->Ln(10);
//        $this->Ln(10);

    }

}


$pdf = new PDF();

$pdf->AddPage("P");


$comp_id = clean_data($_SESSION["comp_id"]);
$year_id = clean_data($_SESSION["year_id"]);

$comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
$vendor_code=find_value('company','vendor_code'," and comp_id='$comp_id'");
if (!empty($vendor_code))
    $vendor_code=' Vendor Code:'.$vendor_code;

$phone=find_value('company','phone'," and comp_id='$comp_id'");
$address=find_value('company','add_line1'," and comp_id='$comp_id'");
$city=find_value('company','city'," and comp_id='$comp_id'");
$ntn=find_value('company','ntn'," and comp_id='$comp_id'");

$pdf->SetFont('Arial', 'BIU', 24);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$v_id = clean_data($_GET['v_id']);

$and ="";
$and .= " and v.comp_id = '$comp_id'";

if (!empty($v_id)) {
    $and .= " and v.voucher_id = '$v_id'";
    $and .= " and v.year_id = '$year_id'";
}else{
    $and .= " and v.voucher_date between '$new_from_date' and '$new_to_date'";
}

try
{
    $voucher_query =  "SELECT v.acct_id, v.voucher_id, v.inv_no, DATE_FORMAT(v.voucher_date, \"%d.%m.%y\") voucher_date, c.comp_name, c.add_line1,c.phone,c.email,
                              c.stax_no, c.ntn, p.acct_name party_name, p.address add_line1, p.city, c.phone c_phone, p.phone, p.ntn party_ntn, p.stax_no party_stax_no, p.cnic
                        FROM sl_dc v 
                        LEFT JOIN company c ON c.comp_id = v.comp_id
                        LEFT JOIN v_party p ON p.acct_id = v.acct_id
                        WHERE 1=1  $and
                        ORDER BY v.bill_no
                       ";

//echo $voucher_query;
    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}
$num_rows = $voucher_result->rowCount();
$_SESSION["num_rows"] = $num_rows;


while ($report_row = $voucher_result->fetch(PDO::FETCH_ASSOC)) {

$voucher_id=$report_row['voucher_id'];
$phone = $report_row['c_phone'];

$ntn = $report_row['ntn'];
$stax_no = $report_row['stax_no'];

$party_name = $report_row['party_name'];
$p_address = $report_row['add_line1'];
$p_city = $report_row['city'];
$p_phone = $report_row['phone'];
$party_stax_no = $report_row['party_stax_no'];

$po_no=find_value("(select ip.po_no, count(*) 
FROM sl_dc v 
LEFT JOIN sl_dcdet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id and v.year_id=d.year_id
LEFT JOIN item i ON d.stock_code = i.stock_code
LEFT JOIN item_party ip on v.acct_id=ip.acct_id and d.stock_code=ip.stock_code where 1=1 $and) v",'po_no','');

/***********************START SUPPLIER BLOCK******************/
$pdf->SetFont('Arial', 'B', 14);

$pdf->Cell(1);

$pdf->SetFont('Arial', 'B', 10);
//SYPPLIER NAME
    $pdf->Ln(10);
    $pdf->Cell(95, 0, 'Vendor Name:   ', 0,1,'L');
    $pdf->Cell(30);
    $pdf->Cell(95, 0, $comp_name, 0,1,'L');

    $pdf->Ln(10);
$pdf->Cell(95, 0, 'To, ', 0,1,'L');
$pdf->Cell(12);
    $pdf->SetFont('Arial', 'UB', 10);
$pdf->Cell(95, 0, $party_name, 0,1,'L');
$pdf->Cell(12);

    $pdf->Ln(1);
    $pdf->Cell(105);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(95, 0, 'PO No:', 0,1,'L');


    $pdf->Cell(125);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(95, 0, $po_no, 0,1,'L');
    $pdf->Cell(145);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->Cell(30,8,$pdf->Code39($pdf->GetX(), $pdf->GetY()-3 ,$po_no,0.4,5),0,1, 'C');
    $pdf->SetTextColor(0, 0, 0);

$pdf->Ln(1);

    $pdf->Cell(105);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(95, 0, 'DC No:', 0,1,'L');


    $pdf->Cell(125);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(95, 0, $report_row['inv_no'], 0,1,'L');
    $pdf->Cell(145);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->Cell(30,8,$pdf->Code39($pdf->GetX(), $pdf->GetY()-3 ,$report_row['inv_no'],0.4,5),0,1, 'C');
    $pdf->SetTextColor(0, 0, 0);

    $pdf->Ln(1);

$pdf->Cell(105);
    $pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(95, 0, 'DC Date:', 0,1,'L');


$pdf->Cell(125);
    $pdf->SetFont('Arial', '', 8);
$pdf->Cell(95, 0, $report_row['voucher_date'], 0,1,'L');
    $pdf->Cell(145);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->Cell(30,8,$pdf->Code39($pdf->GetX(), $pdf->GetY()-3 ,$report_row['voucher_date'],0.4,5),0,1, 'C');
    $pdf->SetTextColor(0, 0, 0);

    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'GP #', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, '', 0,1,'L');


$pdf->Ln(5);


/***********************END SUPPLIER BLOCK******************/

/*****************END MASTER TABLE QUERY*****************/

    $pdf->Cell(1);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(7, 8, 'Sr', 1);
    $pdf->Cell(30, 8, 'Part #', 1, 0, 'C');
    $pdf->Cell(65, 8, 'Part Name', 1, 0, 'C');
    $pdf->Cell(15, 8, 'Qty', 1, 0,'C');
//    $pdf->Cell(30, 8, 'Lot Control No', 1, 0,'C');
    $pdf->Cell(65, 8, 'Bar Code', 1, 0,'C');
    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);
try
{
    $vd_query =  "SELECT
	d.stock_code,
	round(d.qty,0) qty,
	d.pack_no,
	d.qty/d.pack_no pack_qty,
	d.voucher_id,
	i.description,
    d.di_no,
    ip.part_no,
    ip.item_no
    
 	FROM sl_dc v 
 	LEFT JOIN sl_dcdet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id and v.year_id=d.year_id
	LEFT JOIN item i ON d.stock_code = i.stock_code
    LEFT JOIN item_party ip on v.acct_id=ip.acct_id and d.stock_code=ip.stock_code
 	WHERE 1=1 $and and v.voucher_id='$voucher_id'
 	ORDER BY d.lineitem";

//echo $vd_query;

    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$sr = "";
$tot_ex_value=0;
$tot_r_stax=0;
$tot_add_stax=0;
$tot_stax=0;
$tot_r_stax=0;
$tot_itemtot=0;
$tot_qty=0;
$total_stax = "";

while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

    $tot_ex_value += $rd_row['ex_value'];
    $tot_itemtot += $rd_row['itemtot'];
    $tot_qty += $rd_row['qty'];

    $pdf->SetFont('Arial', '', 8);
    $sr += 1;
    $pdf->Cell(1);
    $pdf->Cell(7, 10, $sr.'.', 1);
    $pdf->Cell(30, 10, $rd_row['part_no'], 1, 0, 'L');
    $pdf->Cell(65, 10, $rd_row['description'], 1, 0, 'L');
    $pdf->Cell(15, 10, format_number($rd_row['qty'],0), 1, 0, 'C');
//    $pdf->Cell(30, 10, '', 1, 0, 'C');
    $pdf->SetTextColor(255, 255, 255);
    $pdf->Cell(65,10,$pdf->Code39($pdf->GetX()+2, $pdf->GetY()+1 ,$rd_row['part_no'].'$'.$rd_row['qty'].'$',0.4,8),1,0, 'C');
    $pdf->SetTextColor(0, 0, 0);




    $pdf->Ln(10);
}

    while ($sr<10){
        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(7, 8, $sr.'.', 1);
        $pdf->Cell(30, 8, '', 1);
        $pdf->Cell(65, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
//        $pdf->Cell(30, 8, '', 1);
        $pdf->Cell(65, 8, '', 1);
        $pdf->Ln(8);
    }


    if ($_SESSION["num_rows"]>1)
        $pdf->AddPage("P");

}
$pdf->Output();
